/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.tomcat.util.descriptor.web.ErrorPage;

public class ErrorPageSupport {
    private ConcurrentMap<String, ErrorPage> exceptionPages = new ConcurrentHashMap<String, ErrorPage>();
    private ConcurrentMap<Integer, ErrorPage> statusPages = new ConcurrentHashMap<Integer, ErrorPage>();

    public void add(ErrorPage errorPage) {
        String exceptionType = errorPage.getExceptionType();
        if (exceptionType == null) {
            this.statusPages.put(errorPage.getErrorCode(), errorPage);
        } else {
            this.exceptionPages.put(exceptionType, errorPage);
        }
    }

    public void remove(ErrorPage errorPage) {
        String exceptionType = errorPage.getExceptionType();
        if (exceptionType == null) {
            this.statusPages.remove(errorPage.getErrorCode(), errorPage);
        } else {
            this.exceptionPages.remove(exceptionType, errorPage);
        }
    }

    public ErrorPage find(int statusCode) {
        return (ErrorPage)this.statusPages.get(statusCode);
    }

    @Deprecated
    public ErrorPage find(String exceptionType) {
        return (ErrorPage)this.exceptionPages.get(exceptionType);
    }

    public ErrorPage find(Throwable exceptionType) {
        if (exceptionType == null) {
            return null;
        }
        Class<?> clazz = exceptionType.getClass();
        String name = clazz.getName();
        while (!Object.class.equals(clazz)) {
            ErrorPage errorPage = (ErrorPage)this.exceptionPages.get(name);
            if (errorPage != null) {
                return errorPage;
            }
            if ((clazz = clazz.getSuperclass()) == null) break;
            name = clazz.getName();
        }
        return null;
    }

    public ErrorPage[] findAll() {
        HashSet errorPages = new HashSet();
        errorPages.addAll(this.exceptionPages.values());
        errorPages.addAll(this.statusPages.values());
        return errorPages.toArray(new ErrorPage[0]);
    }
}

